/*
 * @(#)CERAttributeFigure.java  1.0  28. M�rz 2006
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */
package ch.hslu.cm.cer.diagram;

import ch.hslu.cm.cer.model.CERAttribute;
import java.io.IOException;
import ch.hslu.cm.*;
import ch.hslu.cm.simulation.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.undo.*;
import java.beans.*;
import org.jhotdraw.app.action.ActionUtil;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.MoveHandle;
import org.jhotdraw.draw.locator.RelativeDecoratorLocator;
import org.jhotdraw.geom.*;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/**
 * CERAttributeFigure.
 * 
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 28. M�rz 2006 Created.
 */
public class CERAttributeFigure extends TextFigure
        implements DiagramFigure, PropertyChangeListener {

    private BasicStroke dashes = new BasicStroke(1f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL, 0, new float[]{4f, 4f}, 0f);
    /**
     * Figure model.
     */
    private CERAttribute model;

    /**
     * This adapter is used, to connect a TextFigure with the name of
     * the CERAttribute model.
     */
    private static class NameAdapter extends FigureAdapter {

        private CERAttributeFigure target;

        public NameAdapter(CERAttributeFigure target) {
            this.target = target;
        }

        @Override
        public void attributeChanged(final FigureEvent e) {
            if (e.getAttribute().equals(TEXT)) {
                target.model.setName((String) e.getNewValue());

                target.fireUndoableEditHappened(new AbstractUndoableEdit() {

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                        return labels.getString("name");
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        target.model.setName((String) e.getOldValue());
                    }

                    @Override
                    public void redo() throws CannotUndoException {
                        super.redo();
                        target.model.setName((String) e.getNewValue());
                    }
                });
            }
        }
    }
    private NameAdapter nameAdapter;

    /** Creates a new instance. */
    public CERAttributeFigure() {
        EllipseFigure decorator = new EllipseFigure();
        STROKE_PLACEMENT.set(decorator, AttributeKeys.StrokePlacement.OUTSIDE);
        FILL_UNDER_STROKE.set(decorator, AttributeKeys.Underfill.FULL);
        STROKE_WIDTH.set(decorator, ConceptualERDiagram.DIAGRAM_STROKE_WIDTH);
        setDecorator(decorator);
        DECORATOR_INSETS.set(this, new Insets2D.Double(7, 8, 7, 8));

        setEditable(true);
        FONT_BOLD.set(this, false);
        FILL_COLOR.set(this, ConceptualERDiagram.ATTRIBUTE_FILL_COLOR);
        STROKE_COLOR.set(this, ConceptualERDiagram.ATTRIBUTE_STROKE_COLOR);
        TEXT_COLOR.set(this, ConceptualERDiagram.ATTRIBUTE_TEXT_COLOR);
        addFigureListener(nameAdapter = new NameAdapter(this));

        setModel(createAttribute());

        setAttributeEnabled(DECORATOR_INSETS, false);
        setAttributeEnabled(STROKE_TYPE, false);
        setAttributeEnabled(STROKE_DASHES, false);
        setAttributeEnabled(STROKE_PLACEMENT, false);
        setAttributeEnabled(FILL_UNDER_STROKE, false);
        setAttributeEnabled(FONT_BOLD, false);
        setAttributeEnabled(FONT_ITALIC, false);
        setAttributeEnabled(FONT_UNDERLINE, false);
    }
    // DRAWING

    @Override
    protected void drawText(java.awt.Graphics2D g) {
        if (getText() != null || isEditable()) {
            TextLayout layout = getTextLayout();
            layout.draw(g, (float) origin.x, (float) (origin.y + layout.getAscent()));
            if (model != null && model.isDiscriminating()) {
                Stroke oldStroke = g.getStroke();
                g.setStroke(dashes);
                double y = origin.y + layout.getAscent() + layout.getDescent();
                if (model.isPrimaryKey()) {
                    y++;
                }
                g.draw(new Line2D.Double(origin.x, y,
                        origin.x + layout.getAdvance(), y));
                g.setStroke(oldStroke);
            }
        }
    }

    protected void drawConnectors(Graphics2D g) {
        CERAttributeConnector connector = new CERAttributeConnector(this);
        connector.draw(g);
    }
    // SHAPE AND BOUNDS
    // ATTRIBUTES

    @Override
    public void set(AttributeKey key, Object newValue) {
        super.set(key, newValue);
        if (getDecorator() != null) {
            getDecorator().set(key, newValue);
        }
    }
    // EDITING

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new MoveHandle(this, RelativeDecoratorLocator.northEast()));
            handles.add(new MoveHandle(this, RelativeDecoratorLocator.northWest()));
            handles.add(new MoveHandle(this, RelativeDecoratorLocator.southEast()));
            handles.add(new MoveHandle(this, RelativeDecoratorLocator.southWest()));
        }
        return handles;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());

        LinkedList<Action> actions = new LinkedList<Action>();
        Action action;

        Figure item;

        action = new AbstractAction(labels.getFormatted("attributePrimaryKey", getModel().getName())) {

            @Override
            public void actionPerformed(ActionEvent event) {
                model.setPrimaryKey(!model.isPrimaryKey());
                fireUndoableEditHappened(new AbstractUndoableEdit() {

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                        return labels.getString("attributePrimaryKey");
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        model.setPrimaryKey(!model.isPrimaryKey());
                    }

                    @Override
                    public void redo() throws CannotUndoException {
                        super.redo();
                        model.setPrimaryKey(!model.isPrimaryKey());
                    }
                });
            }
        };
        action.putValue(ActionUtil.SELECTED_KEY, model.isPrimaryKey());
        actions.add(action);

        action = new AbstractAction(labels.getFormatted("attributeDiscriminating", getModel().getName())) {

            @Override
            public void actionPerformed(ActionEvent event) {
                model.setDiscriminating(!model.isDiscriminating());
                fireUndoableEditHappened(new AbstractUndoableEdit() {

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                        return labels.getString("attributeDiscriminating");
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        model.setDiscriminating(!model.isDiscriminating());
                    }

                    @Override
                    public void redo() throws CannotUndoException {
                        super.redo();
                        model.setDiscriminating(!model.isDiscriminating());
                    }
                });
            }
        };
        action.putValue(ActionUtil.SELECTED_KEY, model.isDiscriminating());
        actions.add(action);



        action = new AbstractAction(labels.getFormatted("attributeMultivalued", getModel().getName())) {

            @Override
            public void actionPerformed(ActionEvent event) {
                model.setMultivalued(!model.isMultivalued());
                fireUndoableEditHappened(new AbstractUndoableEdit() {

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                        return labels.getString("attributeMultivalued");
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        model.setMultivalued(!model.isMultivalued());
                    }

                    @Override
                    public void redo() throws CannotUndoException {
                        super.redo();
                        model.setMultivalued(!model.isMultivalued());
                    }
                });
            }
        };
        action.putValue(ActionUtil.SELECTED_KEY, model.isMultivalued());
        actions.add(action);

        action = new AbstractAction(labels.getFormatted("attributeDerived", getModel().getName())) {

            @Override
            public void actionPerformed(ActionEvent event) {
                model.setDerived(!model.isDerived());
                fireUndoableEditHappened(new AbstractUndoableEdit() {

                    @Override
                    public String getPresentationName() {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("ch.hslu.cm.cer.Labels", Locale.getDefault());
                        return labels.getString("attributeDerived");
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        model.setDerived(!model.isDerived());
                    }

                    @Override
                    public void redo() throws CannotUndoException {
                        super.redo();
                        model.setDerived(!model.isDerived());
                    }
                });
            }
        };
        action.putValue(ActionUtil.SELECTED_KEY, model.isDerived());
        actions.add(action);

        return actions;
    }

    // CONNECTING
    public int getConnectionCount() {
        return getModel().getRelationships().size();
    }

    public int getConnectionIndex(DiagramFigure f) {
        return getModel().getRelationships().indexOf(f.getModel());
    }

    /**
     * Gets a connector for this figure at the given location.
     * A figure can have different connectors at different locations.
     */
    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        if (contains(p)) {
            return new CERAttributeConnector(this);
        } else {
            return null;
        }
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        if (c.getOwner() == this) {
            return c;
        }

        return new CERAttributeConnector(this);
    }

    // COMPOSITE FIGURES
    // CLONING
    // EVENT HANDLING
    public CERAttribute getSimulatedEntityType() {
        return (CERAttribute) getModel();
    }

    protected CERAttribute createAttribute() {
        CERAttribute attribute = new CERAttribute();
        return attribute;
    }

    public void setModel(CERAttribute m) {
        willChange();
        if (model != null) {
            model.removePropertyChangeListener(this);
        }
        model = m;
        if (model != null) {
            model.addPropertyChangeListener(this);
            setText(model.getName());

            updateDecorator();
        }
        changed();
    }

    @Override
    public CERAttribute getModel() {
        return model;
    }

    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }

    private Simulation getSimulation() {
        return getDiagram().getSimulation();
    }

    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if ((drawing instanceof Diagram) && getModel() != null) {
            getSimulation().add(getModel());
        }
    }

    @Override
    public void removeNotify(Drawing drawing) {
        if (getDrawing() != null && getModel() != null) {
            getSimulation().remove(getModel());
        }
        super.removeNotify(drawing);
    }

    @Override
    public CERAttributeFigure clone() {
        CERAttributeFigure that = (CERAttributeFigure) super.clone();
        that.nameAdapter = new NameAdapter(that);
        that.addFigureListener(that.nameAdapter);
        that.setModel((CERAttribute) this.model.clone());
        return that;
    }

    public SimulatedElement getSimulatedObject() {
        return model;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        double x = in.getAttribute("x", 0d);
        double y = in.getAttribute("y", 0d);
        double w = in.getAttribute("w", 0d);
        double h = in.getAttribute("h", 0d);
        setBounds(new Point2D.Double(x, y), new Point2D.Double(x + w, y + h));
        readAttributes(in);
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((CERAttribute) in.readObject(0));
        in.closeElement();
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double r = getBounds();
        out.addAttribute("x", r.x);
        out.addAttribute("y", r.y);
        writeAttributes(out);
        out.openElement("Model");
        out.writeObject(getModel());
        out.closeElement();
    }

    @Override
    public int getLayer() {
        return ConceptualERDiagram.OBJECT_LAYER;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        willChange();
        updateDecorator();
        changed();
    }

    protected void updateDecorator() {
        AbstractAttributedFigure decorator = (AbstractAttributedFigure) getDecorator();
        if (model != null && decorator != null) {
            decorator.setAttributeEnabled(STROKE_TYPE, true);
            STROKE_TYPE.set(decorator,
                    model.isMultivalued()
                    ? StrokeType.DOUBLE
                    : StrokeType.BASIC);
            decorator.setAttributeEnabled(STROKE_TYPE, false);
            decorator.setAttributeEnabled(STROKE_INNER_WIDTH_FACTOR, true);
            STROKE_INNER_WIDTH_FACTOR.set(decorator, 3d);
            decorator.setAttributeEnabled(STROKE_INNER_WIDTH_FACTOR, false);
            decorator.setAttributeEnabled(STROKE_DASHES, true);
            if (model.isDerived()) {
                decorator.set(STROKE_DASHES, new double[]{3d, 3d});
            } else {
                decorator.set(STROKE_DASHES, null);
            }
            decorator.setAttributeEnabled(STROKE_DASHES, false);

            setAttributeEnabled(FONT_UNDERLINE, true);
            FONT_UNDERLINE.set(this, model.isPrimaryKey());
            setAttributeEnabled(FONT_UNDERLINE, false);
        }
    }
}
